<?php

namespace App\Models\Admin;

use Carbon\Carbon;
use App\Models\User;
use App\Base\Uuid\UuidModel;
use App\Models\Traits\HasActive;
use Illuminate\Database\Eloquent\Model;
use App\Models\Traits\HasActiveCompanyKey;
use Nicolaslopezj\Searchable\SearchableTrait;
use Grimzy\LaravelMysqlSpatial\Eloquent\SpatialTrait;

class PeakZone extends Model
{
    use HasActive, UuidModel,SearchableTrait,HasActiveCompanyKey,SpatialTrait;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'peak_zones';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'zone_id','name','active','coordinates','lat','lng','start_time','end_time','distance_price_percentage'
    ];

    protected $spatialFields = [
        'coordinates'
    ];

    protected $searchable = [
        /**
         * Columns and their priority in search results.
         * Columns with higher values are more important.
         * Columns with equal values have equal importance.
         *
         * @var array
         */
        'columns' => [
            'peak_zones.name' => 20,
            'zones.name' => 20,
        ],
    ];
    /**
     * The relationships that can be loaded with query string filtering includes.
     *
     * @var array
     */
    public $includes = [
        'zoneDetail'
    ];

     protected $appends = [
        'converted_start_time','converted_end_time'
     ];

    /**
     * The admin that the uploaded image belongs to.
     * @tested
     *
     * @return \Illuminate\Database\Eloquent\Relations\belongsTo
     */
    public function zoneDetail()
    {
        return $this->belongsTo(Zone::class, 'zone_id', 'id');
    }


    /**
    * Get formated and converted timezone of user's created at.
    *
    * @param string $value
    * @return string
    */
    public function getConvertedCreatedAtAttribute()
    {
        if ($this->created_at==null||!auth()->user()) {
            return null;
        }
        $timezone = auth()->user()->timezone?:env('SYSTEM_DEFAULT_TIMEZONE');
        return Carbon::parse($this->created_at)->setTimezone($timezone)->format('jS M h:i A');
    }
    /**
    * Get formated and converted timezone of user's created at.
    *
    * @param string $value
    * @return string
    */
    public function getConvertedUpdatedAtAttribute()
    {
        if ($this->updated_at==null||!auth()->user()) {
            return null;
        }
        $timezone = auth()->user()->timezone?:env('SYSTEM_DEFAULT_TIMEZONE');
        return Carbon::parse($this->updated_at)->setTimezone($timezone)->format('jS M h:i A');
    }

     /**
         * Get formatted and converted timezone of user's start time.
         * @return string
         */
        public function getConvertedStartTimeAttribute()
        {
            if ($this->start_time == null) {
                return null;
            }
            $timezone = $this->zoneDetail->serviceLocation->timezone ?: env('SYSTEM_DEFAULT_TIMEZONE');
            return Carbon::parse($this->start_time)->setTimezone($timezone)->format('h:i A');
        }

          /**
         * Get formatted and converted timezone of user's end time.
         * @return string
         */
        public function getConvertedEndTimeAttribute()
        {
            if ($this->end_time == null) {
                return null;
            }
            $timezone = $this->zoneDetail->serviceLocation->timezone ?: env('SYSTEM_DEFAULT_TIMEZONE');
            return Carbon::parse($this->end_time)->setTimezone($timezone)->format('h:i A');
        }

   
}
